(************************************************************************
 *                                                                      *
 *   (C) 2002-2006 Antoine Potten                                       *
 *   http://www.antp.be/software                                        *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit functions_html;

interface

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function HTMLDecode(const Value: string): string;
function HTMLRemoveTags(const Value: string): string;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

implementation

uses
  SysUtils,

  functions_str;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

const
  Symbols: array [32..255] of string = (
                        'nbsp',   '',       'quot',   '',       '',       '',       'amp',    '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    'lt',     '',       'gt',     '',       '',       '',       '',       '',       '',       '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    '',       '',       '',       '',       '',       '',       '',       '',       '',       '',
    '',       'iexcl',  'cent',   'pound',  'curren', 'yen',    'brvbar', 'sect',   'uml',    'copy',
    'ordf',   'laquo',  'not',    'shy',    'reg',    'macr',   'deg',    'plusmn', 'sup2',   'sup3',
    'acute',  'micro',  'para',   'middot', 'cedil',  'sup1',   'ordm',   'raquo',  'frac14', 'frac12',
    'frac34', 'iquest', 'Agrave', 'Aacute', 'Acirc',  'Atilde', 'Auml',   'Aring',  'AElig',  'Ccedil',
    'Egrave', 'Eacute', 'Ecirc',  'Euml',   'Igrave', 'Iacute', 'Icirc',  'Iuml',   'ETH',    'Ntilde',
    'Ograve', 'Oacute', 'Ocirc',  'Otilde', 'Ouml',   'times',  'Oslash', 'Ugrave', 'Uacute', 'Ucirc',
    'Uuml',   'Yacute', 'THORN',  'szlig',  'agrave', 'aacute', 'acirc',  'atilde', 'auml',   'aring',
    'aelig',  'ccedil', 'egrave', 'eacute', 'ecirc',  'euml',   'igrave', 'iacute', 'icirc',  'iuml',
    'eth',    'ntilde', 'ograve', 'oacute', 'ocirc',  'otilde', 'ouml',   'divide', 'oslash', 'ugrave',
    'uacute', 'ucirc',  'uuml',   'yacute', 'thorn',  'yuml'
  );

function HTMLDecode(const Value: string): string;
var
  i, Max, p1, p2: Integer;
  Symbol: string;
  SymbolLength: Integer;
begin
  result := '';
  Max := Length(Value);
  i := 1;
  while i <= Max do
  begin
    if (Value[i] = '&') and (i + 1 < Max) then
    begin
      Symbol := copy(Value, i + 1, Max);
      p1 := Pos(' ', Symbol);
      p2 := Pos(';', Symbol);
      if (p2 > 0) and ((p2 < p1) xor (p1 = 0)) then
      begin
        Symbol := Copy(Symbol, 1, pos(';', Symbol) - 1);
        SymbolLength := Length(Symbol) + 1;
        if Symbol[1] <> '#' then
        begin
          Symbol := IntToStr(IndexStr(Symbol, Symbols) + 32);
        end else
          Delete(Symbol, 1, 1);
        Symbol := char(StrToIntDef(Symbol, 0));
        result := result + Symbol;
        inc(i, SymbolLength);
      end else
        result := result + Value[i];
    end else
      result := result + Value[i];
    inc(i);
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function HTMLRemoveTags(const Value: string): string;
var
  i, Max: Integer;
begin
  result := '';
  Max := Length(Value);
  i := 1;
  while i <= Max do
  begin
    if Value[i] = '<' then
    begin
      repeat
        inc(i);
      until (i > Max) or (Value[i-1] = '>');
    end else
    begin
      result := result + Value[i];
      inc(i);
    end;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

end.
