(************************************************************************
 *                                                                      *
 *   (C) 2002-2006 Antoine Potten                                       *
 *   http://www.antp.be/software                                        *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit functions_sys;

interface

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function IsMSHTMLInstalled: Boolean;
function IsGeckoInstalled: Boolean;
procedure AssociateFileExtension(IconPath, ProgramName, Path, Extension: string);
procedure RebuildIconCache;

var
  IsWindowsNT,
  IsWindowsXP,
  IsThemedXP: Boolean;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

implementation

uses
  SysUtils, Windows, Registry, Messages,
  AntCommon,
  functions_str;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function IsMSHTMLInstalled: Boolean;
begin
  Result := False;
  with TRegistry.Create(KEY_EXECUTE) do
    try
      RootKey := HKEY_LOCAL_MACHINE;
      if OpenKeyReadOnly('\SOFTWARE\Microsoft\Internet Explorer') then
      begin
        Result := StrToIntTrunc(ReadString('Version'), 0) >= 4;
        CloseKey;
      end;
    finally
      Free;
    end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function IsGeckoInstalled: Boolean;
begin
  Result := False;
  with TRegistry.Create(KEY_EXECUTE) do
    try
      RootKey := HKEY_CLASSES_ROOT;
      if OpenKeyReadOnly('\CLSID\{1339B54C-3453-11D2-93B9-000000000000}\InprocServer32') then
      begin
        Result := Pos('mozctlx.dll', ReadString('')) > 0;
        CloseKey;
      end;
    finally
      Free;
    end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure AssociateFileExtension(IconPath, ProgramName, Path, Extension: string);
  // comes from JVCL
begin
  with TRegistry.Create do
  begin
    RootKey := HKEY_CLASSES_ROOT;
    OpenKey(ProgramName, True);
    WriteString('', ProgramName);
    if IconPath <> '' then
    begin
      OpenKey('DefaultIcon', True);
      WriteString('', IconPath);
    end;
    CloseKey;
    OpenKey(ProgramName, True);
    OpenKey('shell', True);
    OpenKey('open', True);
    OpenKey('command', True);
    WriteString('', '"' + Path + '" "%1"');
    Free;
  end;
  with TRegistry.Create do
  begin
    RootKey := HKEY_CLASSES_ROOT;
    OpenKey('.' + extension, True);
    WriteString('', ProgramName);
    Free;
  end;
  RebuildIconCache;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure RebuildIconCache;
  // comes from JVCL
var
  Dummy: DWORD;
begin
  SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, SPI_SETNONCLIENTMETRICS,
    Longint(PChar('WindowMetrics')), SMTO_NORMAL or SMTO_ABORTIFHUNG, 10000, Dummy);
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

initialization
  IsWindowsNT := Win32Platform = VER_PLATFORM_WIN32_NT;
  IsWindowsXP := (IsWindowsNT) and (((Win32MajorVersion = 5) and (Win32MinorVersion >= 1)) or (Win32MajorVersion > 5));
  IsThemedXP := AntCommon.IsThemedXP;
end.
